//To Calculate the performance parameters for a medium T-network transmission line for a specific given quantities
// Determine efficiency and regulation of 3 phase 100km 50 hz, transmission line delivering 20 MW at a pf of 0.8 lagging and 66 kV to a balance load.The conductors are copper each having resistance 0.1 ohm per km, 1.5 cm outside dia, spaced equilaterally 2 mts between centres.Neglect leakage and use Nominal T method. ( C L Wadhwa, Ch-4 ex.4.5)
//Windows 10
//5.5.2
clc;
clear;
vr=input('enter the value of recieving end voltage');
vrph=vr/1.73;
p=input('enter the supply power');
pf=input('enter the power factor');
spf=sin(acos(pf));
ir=p/(1.73*vr*pf);
disp(ir,'receiving end current magnitude');
spf=sin(acos(pf));
r=input('enter the resistance');
xl=input('enter the reactance');
xc=input('enter the capcitive susceptance');
z=r+%i*xl;
imp2=z/2
ad=%i*(314*xc);
irv=ir*(pf-%i*spf);
v1=vrph+(irv*imp2);
ic=ad*v1;
is=ic+irv;
isa=abs(is);
disp(isa,'sending end current');
vs=v1+(is*(z/2));
vsh=abs(vs);
disp(vsh,'sending end voltage');
e=phasemag(vs);
f=phasemag(is);
os=e-f;
pfs=cosd(os);
disp(pfs, 'powerfactor sendingend');
op=3*vsh*pfs*isa;
disp(op, 'input power is');
eff=(p/op)*100;
disp(eff,'efficiency is');
reg=((vsh-vrph)/vrph)*100;
disp(reg,'regulation of the line is');
